/*
 * Decompiled with CFR 0.152.
 */
package com.nethersdelight.integration.jei.category;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nethersdelight.core.registry.NDBlocks;
import com.nethersdelight.core.tag.NDTags;
import com.nethersdelight.core.utility.NDTextUtils;
import com.nethersdelight.integration.jei.NDRecipeTypes;
import com.nethersdelight.integration.jei.resource.CompositionDummy;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.MethodsReturnNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CompositionRecipeCategory
implements IRecipeCategory<CompositionDummy> {
    public static final ResourceLocation UID = new ResourceLocation("nethersdelight", "composition");
    private static final int slotSize = 22;
    private final Component title = NDTextUtils.getTranslation("jei.composition", new Object[0]);
    private final IDrawable background;
    private final IDrawable slotIcon;
    private final IDrawable icon;
    private final ItemStack soulCompost;
    private final ItemStack richSoulSoil;

    public CompositionRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("nethersdelight", "textures/gui/jei/composition.png");
        this.background = helper.createDrawable(backgroundImage, 0, 0, 118, 80);
        this.soulCompost = new ItemStack((ItemLike)NDBlocks.SOUL_COMPOST.get());
        this.richSoulSoil = new ItemStack((ItemLike)NDBlocks.RICH_SOUL_SOIL.get());
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)this.richSoulSoil);
        this.slotIcon = helper.createDrawable(backgroundImage, 119, 0, 22, 22);
    }

    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    public Class<? extends CompositionDummy> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    public RecipeType<CompositionDummy> getRecipeType() {
        return NDRecipeTypes.COMPOSITION;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, CompositionDummy compositionRecipe, IFocusGroup iIngredients) {
        List accelerators = ForgeRegistries.BLOCKS.tags().getTag(NDTags.SOUL_COMPOST_ACTIVATORS).stream().map(ItemStack::new).collect(Collectors.toList());
        recipeLayout.addSlot(RecipeIngredientRole.INPUT, 9, 26).addItemStack(this.soulCompost);
        recipeLayout.addSlot(RecipeIngredientRole.OUTPUT, 93, 26).addItemStack(this.richSoulSoil);
        recipeLayout.addSlot(RecipeIngredientRole.RENDER_ONLY, 64, 54).addItemStacks(accelerators);
    }

    public void draw(CompositionDummy recipe, IRecipeSlotsView recipeSlotsView, PoseStack ms, double mouseX, double mouseY) {
        this.slotIcon.draw(ms, 63, 53);
    }

    public List<Component> getTooltipStrings(CompositionDummy recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (CompositionRecipeCategory.inIconAt(40, 38, mouseX, mouseY)) {
            return ImmutableList.of((Object)CompositionRecipeCategory.translateKey(".light"));
        }
        if (CompositionRecipeCategory.inIconAt(53, 38, mouseX, mouseY)) {
            return ImmutableList.of((Object)CompositionRecipeCategory.translateKey(".fluid"));
        }
        if (CompositionRecipeCategory.inIconAt(67, 38, mouseX, mouseY)) {
            return ImmutableList.of((Object)CompositionRecipeCategory.translateKey(".accelerators"));
        }
        return Collections.emptyList();
    }

    private static boolean inIconAt(int iconX, int iconY, double mouseX, double mouseY) {
        int icon_size = 11;
        return (double)iconX <= mouseX && mouseX < (double)(iconX + 11) && (double)iconY <= mouseY && mouseY < (double)(iconY + 11);
    }

    private static TranslatableComponent translateKey(@Nonnull String suffix) {
        return new TranslatableComponent("nethersdelight.jei.composition" + suffix);
    }
}

